<?php $__env->startSection('content'); ?>



<h4 class="mb-4" data-aos="fade-down" data-aos-easing="linear"><i class="bi bi-gear me-2"></i><?php echo e(trans('settings')); ?></h4>
<div class="row g-4" data-aos="fade-up" data-aos-easing="linear">
    <div class="col-12">
        <div class="vine-tabs pb-0 px-2 px-lg-0 rounded-top">
            <ul class="nav nav-tabs nav-bottom-line nav-responsive border-0 nav-justified" role="tablist">
                <li class="nav-item" role="presentation">
                    <a class="nav-link mb-0 <?php echo e(Route::is('user.profile') ? 'active' : ''); ?>" href="<?php echo e(route('user.profile')); ?>">
                        <i class="bi bi-gear fa-fw me-2"></i><?php echo e(trans('edit_profile')); ?>

                    </a>
                </li>
                <li class="nav-item" role="presentation">
                    <a class="nav-link mb-0 <?php echo e(Route::is('user.password') ? 'active' : ''); ?>" href="<?php echo e(route('user.password')); ?>">
                        <i class="bi bi-lock me-2"></i> <?php echo e(trans('security_settings')); ?>

                    </a>
                </li>
                <li class="nav-item" role="presentation">
                    <a class="nav-link mb-0 <?php echo e(Route::is('user.email.notifications') ? 'active' : ''); ?>" href="<?php echo e(route('user.email.notifications')); ?>">
                        <i class="bi bi-bell me-2"></i> <?php echo e(trans('email_notifications')); ?>

                    </a>
                </li>
            </ul>
        </div>
    </div>
</div>

<div class="row g-4">
    <div class="col-12">
        <div class="mt-5">

          <?php if(Route::is('user.profile') ): ?>
            <div data-aos="fade-up" data-aos-easing="linear">
                <div class="dashboard-card">
                    <div class="dashboard-header">
                        <h4><?php echo e(trans('profile_details')); ?></h4>
                    </div>
                    <div class="dashboard-body">


                        <form id="user_profile_form" method="POST">
                            <?php echo csrf_field(); ?>

                            <input type="hidden" name="user_id" id="user_id" value="<?php echo e(Auth::user()->id); ?>">
                            <input type="hidden" name="old_image" id="old_image" value="<?php echo e(Auth::user()->image); ?>">

                            <div class="col-lg-12 mb-5 d-flex justify-content-left" io-image-input="true">

                            <div class="photo me-5">
                                <div class="d-block">
                                    <div class="image-picker">
                                        <img id='image_preview' class="image previewImage" src="<?php echo e(my_asset('uploads/users/'. Auth::user()->image)); ?>">
                                        <span class="picker-edit rounded-circle text-gray-500 fs-small" data-bs-toggle="tooltip" data-placement="top" data-bs-original-title="Change Image">
                                            <label>
                                                <i class="bi bi-pencil"></i>

                                                <input id="image" class="image-upload d-none" accept=".png, .jpg, .jpeg" name="image" type="file">
                                            </label>
                                            <div class="invalid-feedback"></div>
                                        </span>
                                    </div>
                                </div>
                            </div>

                            </div>

                            <div class="row g-3">
                              <div class="col-sm-12">
                                  <label class="form-label"><?php echo e(trans('name')); ?>*</label>
                                  <input type="text" name="name" id="name" value="<?php echo e(Auth::user()->name); ?>" placeholder="<?php echo e(trans('name')); ?>">
                                  <div class="invalid-feedback"></div>
                              </div>
                              <div class="col-sm-12">
                                  <label class="form-label"><?php echo e(trans('email')); ?>*</label>
                                  <input type="text" name="email" id="email" value="<?php echo e(Auth::user()->email); ?>" placeholder="<?php echo e(trans('email')); ?>">
                                  <div class="invalid-feedback"></div>
                              </div>
                              <div class="col-sm-12">
                                  <label><?php echo e(trans('username')); ?>*</label>
                                  <input type="text" name="username" id="username" value="<?php echo e(Auth::user()->username); ?>" placeholder="<?php echo e(trans('username')); ?>">
                                  <div class="invalid-feedback"></div>
                              </div>
                              <div class="col-sm-6">
                                  <label><?php echo e(trans('profession')); ?></label>
                                  <input name="profession" id="profession" type="text" value="<?php echo e(Auth::user()->profession); ?>" placeholder="Eg. Web Developer">
                                  <div class="invalid-feedback"></div>
                              </div>
                              <div class="col-sm-6">
                                  <label><?php echo e(trans('gender')); ?></label>
                                  <select name="gender">
                                     <option value="Male" <?php echo e(Auth::user()->gender == 'Male' ? 'selected="selected"' : ''); ?>><?php echo e(trans('male')); ?></option>
                                     <option value="Female" <?php echo e(Auth::user()->gender == 'Female' ? 'selected="selected"' : ''); ?>><?php echo e(trans('female')); ?></option>
                                  </select>
                                  <div class="invalid-feedback"></div>
                              </div>
                              <div class="col-sm-12">
                                  <label class="form-label"><?php echo e(trans('bio')); ?></label>
                                  <textarea name="bio" id="bio" rows="5" placeholder="Bio"><?php echo e(Auth::user()->bio); ?></textarea>
                                  <div class="invalid-feedback"></div>
                              </div>
                              <div class="col-sm-6">
                                  <label><?php echo e(trans('location')); ?></label>
                                  <input name="location" id="location" type="text" value="<?php echo e(Auth::user()->location); ?>" placeholder="Ex.San Francisco, CA">
                                  <div class="invalid-feedback"></div>
                              </div>
                              <div class="col-sm-6">
                                  <label><?php echo e(trans('country')); ?></label>
                                    <select name="country" id="country">
                                        <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($country->code); ?>" <?php echo e(Auth::user()->country == $country->code ? 'selected="selected"' : ''); ?>><?php echo e($country->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                <div class="invalid-feedback"></div>
                              </div>

                              <div class="col-12">
                                  <label class="form-label"><?php echo e(trans('your_website')); ?></label>
                                  <input type="text" name="website" id="website" value="<?php echo e(Auth::user()->website); ?>" placeholder="<?php echo e(trans('your_website')); ?>">
                                  <div class="invalid-feedback"></div>
                              </div>
                              <div class="col-12">
                                  <label class="form-label">Twitter</label>
                                  <div class="d-flex justify-content-center">
                                      <span class="input-group-text border-0 bg-input" id="basic-addon1_"><i class="bi-twitter"></i></span>
                                      <input type="text" name="twitter" id="twitter" value="<?php echo e(Auth::user()->twitter); ?>" placeholder="Twitter Username">
                                      <div class="invalid-feedback"></div>
                                  </div>
                              </div>
                              <div class="col-12">
                                  <label class="form-label">Facebook</label>
                                  <div class="d-flex justify-content-center">
                                      <span class="input-group-text border-0 bg-input" id="basic-addon1_01"><i class="bi-facebook"></i></span>
                                      <input type="text" name="facebook" id="facebook" value="<?php echo e(Auth::user()->facebook); ?>" placeholder="Facebook Username">
                                      <div class="invalid-feedback"></div>
                                  </div>
                              </div>
                              <div class="col-12"><label class="form-label">Instagram</label>
                                  <div class="d-flex justify-content-center">
                                      <span class="input-group-text border-0 bg-input" id="basic-addon1_02"><i class="bi-instagram"></i></span>
                                      <input type="text" name="instagram" id="instagram" value="<?php echo e(Auth::user()->instagram); ?>" placeholder="Instagram Username">
                                      <div class="invalid-feedback"></div>
                                  </div>
                              </div>
                              <div class="col-12">
                                  <label class="form-label">Linkedin</label>
                                  <div class="d-flex justify-content-center">
                                      <span class="input-group-text border-0 bg-input" id="basic-addon1_02"><i class="bi-linkedin"></i></span>
                                      <input type="text" name="linkedin" id="linkedin" value="<?php echo e(Auth::user()->linkedin); ?>" placeholder="Linkedin Username">
                                      <div class="invalid-feedback"></div>
                                  </div>
                              </div>
                            </div>
                            <div class="d-flex pt-5">
                              <button type="submit" id="user_profile_btn" class="btn btn-mint me-3"><?php echo e(trans('save_changes')); ?></button>
                            </div>
                        </form>

                    </div>
                </div><!--/dashboard-card-->
            </div><!-- Tab content 1 END -->
          <?php elseif(Route::is('user.password') ): ?>
            <div data-aos="fade-up" data-aos-easing="linear">

                <div class="dashboard-card">
                    <div class="dashboard-header">
                        <h4><?php echo e(trans('change_password')); ?></h4>
                    </div>
                    <div class="dashboard-body">

                        <!-- Password -->
                        <form id="user_password_form" method="POST">
                            <?php echo csrf_field(); ?>

                            <div class="row">
                                <div class="col-sm-12 mb-4">
                                    <label class="form-label fs-base"><?php echo e(trans('current_password')); ?></label>
                                    <div class="password-toggle">
                                        <input type="password" name="current_password" id="current_password" placeholder="<?php echo e(trans('current_password')); ?>">
                                        <label class="password-toggle-btn" aria-label="Show/hide password">
                                            <input class="password-toggle-check" id="togglePassword-1" type="checkbox">
                                            <span class="password-toggle-indicator"></span>
                                        </label>
                                        <div class="invalid-feedback"></div>
                                    </div>
                                </div>
                                <div class="col-sm-12 mb-4">
                                    <label class="form-label fs-base"><?php echo e(trans('new_password')); ?></label>
                                    <div class="password-toggle">
                                        <input type="password" name="new_password" id="new_password" placeholder="<?php echo e(trans('new_password')); ?>">
                                        <label class="password-toggle-btn" aria-label="Show/hide password">
                                            <input class="password-toggle-check" id="togglePassword-2" type="checkbox">
                                            <span class="password-toggle-indicator"></span>
                                        </label>
                                        <div class="invalid-feedback"></div>
                                    </div>
                                </div>
                                <div class="col-sm-12 mb-4">
                                    <label class="form-label fs-base"><?php echo e(trans('confirm_new_password')); ?></label>
                                    <div class="password-toggle">
                                        <input type="password" name="confirm_password" id="confirm_password" placeholder="<?php echo e(trans('confirm_new_password')); ?>">
                                        <label class="password-toggle-btn" aria-label="Show/hide password">
                                            <input class="password-toggle-check" id="togglePassword-3" type="checkbox">
                                            <span class="password-toggle-indicator"></span>
                                        </label>
                                        <div class="invalid-feedback"></div>
                                    </div>
                                </div>
                            </div>

                            <div class="d-flex mb-3 pt-2">
                            <button type="submit" id="user_password_btn" class="btn btn-mint me-3"><?php echo e(trans('save_changes')); ?></button>
                            </div>
                        </form>

                    </div>
                </div><!--/dashboard-card-->
            </div><!-- Tab content 3 END -->
            <?php elseif(Route::is('user.email.notifications') ): ?>
              <div data-aos="fade-up" data-aos-easing="linear">

                  <div class="dashboard-card">
                      <div class="dashboard-header">
                          <h4><?php echo e(trans('email_notifications')); ?></h4>
                      </div>
                      <div class="dashboard-body">

                          <form id="user_email_form" method="POST">
                              <?php echo csrf_field(); ?>

                              <input type="hidden" name="user_id" id="user_id" value="<?php echo e(Auth::user()->id); ?>">
                              <div class="row align-items-end pb-3 mb-2 mb-sm-4">
                                <div class="col-lg-6 col-sm-7">
                                  <label class="form-label fs-base"><?php echo e(add('your_email')); ?></label>
                                  <input type="text" name="email" value="<?php echo e(Auth::user()->email); ?>" readonly>
                                </div>
                              </div>

                              <div class="form-group">
                                  <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                      <input type="checkbox" name="email_comment" class="custom-control-input" value="1" id="email_comment" <?php echo e(Auth::user()->email_comment == '1' ? 'checked' : ''); ?>>
                                      <label class="custom-control-label" for="email_comment"><?php echo e(trans('new_comment_on_your_post')); ?></label>
                                      <p class="text-muted mb-2"></p>
                                  </div>
                              </div>
                              <div class="form-group">
                                  <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                      <input type="checkbox" name="email_reply" class="custom-control-input" value="1" id="email_reply" <?php echo e(Auth::user()->email_reply == '1' ? 'checked' : ''); ?>>
                                      <label class="custom-control-label" for="email_reply"><?php echo e(trans('new_reply_on_your_comment')); ?></label>
                                      <p class="text-muted mb-2"></p>
                                  </div>
                              </div>
                              <div class="form-group">
                                  <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                      <input type="checkbox" name="email_follower" class="custom-control-input" value="1" id="email_follower" <?php echo e(Auth::user()->email_follower == '1' ? 'checked' : ''); ?>>
                                      <label class="custom-control-label" for="email_follower"><?php echo e(trans('new_follower')); ?></label>
                                      <p class="text-muted mb-2"></p>
                                  </div>
                              </div>
                              <div class="form-group">
                                  <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                      <input type="checkbox" name="email_message" class="custom-control-input" value="1" id="email_message" <?php echo e(Auth::user()->email_message == '1' ? 'checked' : ''); ?>>
                                      <label class="custom-control-label" for="email_message"><?php echo e(trans('new_message')); ?></label>
                                      <p class="text-muted mb-2"></p>
                                  </div>
                              </div>
                              <div class="form-group">
                                  <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                      <input type="checkbox" name="email_tip" class="custom-control-input" value="1" id="email_tip" <?php echo e(Auth::user()->email_tip == '1' ? 'checked' : ''); ?>>
                                      <label class="custom-control-label" for="email_tip"><?php echo e(trans('received_a_tip')); ?></label>
                                      <p class="text-muted mb-2"></p>
                                  </div>
                              </div>
                              <div class="form-group">
                                  <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                      <input type="checkbox" name="email_funds" class="custom-control-input" value="1" id="email_funds" <?php echo e(Auth::user()->email_funds == '1' ? 'checked' : ''); ?>>
                                      <label class="custom-control-label" for="email_funds"><?php echo e(trans('added_funds')); ?></label>
                                      <p class="text-muted mb-2"></p>
                                  </div>
                              </div>



                              <div class="d-flex mb-3 pt-2">
                              <button type="submit" id="user_email_btn" class="btn btn-mint me-3"><?php echo e(trans('save_changes')); ?></button>
                              </div>
                          </form>

                      </div>
                  </div><!--/dashboard-card-->
              </div><!-- Tab content 3 END -->
          <?php endif; ?>

        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>

<script>

// Toggle Passwords

    $('#togglePassword-1').on('click', function(){
      var passInput=$("#current_password");
      if(passInput.attr('type')==='password')
        {
          passInput.attr('type','text');
      }else{
         passInput.attr('type','password');
      }
    });

    $('#togglePassword-2').on('click', function(){
      var passInput=$("#new_password");
      if(passInput.attr('type')==='password')
        {
          passInput.attr('type','text');
      }else{
         passInput.attr('type','password');
      }
    });

    $('#togglePassword-3').on('click', function(){
    var passInput=$("#confirm_password");
    if(passInput.attr('type')==='password')
        {
        passInput.attr('type','text');
    }else{
        passInput.attr('type','password');
    }
    });


// Image Change
   $(document).on('change', '#image', function () {
     if (isValidFile($(this), '#validationErrorsBox')) {
       displayPhoto(this, '#image_preview');
     }
   });

    $(function() {

       // update user ajax request
       $(document).on('submit', '#user_profile_form', function(e) {
           e.preventDefault();
           start_load();
           const fd = new FormData(this);
           $("#user_profile_btn").text('<?php echo e(trans('updating')); ?>...');
           $.ajax({
               method: 'POST',
               url: '<?php echo e(route('user.profile')); ?>',
               data: fd,
               cache: false,
               contentType: false,
               processData: false,
               dataType: 'json',
               success: function(response) {
                   end_load();

                   if (response.status == 400) {

                       showError('name', response.messages.name);
                       showError('email', response.messages.email);
                       showError('username', response.messages.username);
                       showError('image', response.messages.image);
                       $("#user_profile_btn").text('<?php echo e(trans('save_changes')); ?>');

                   }else if (response.status == 200) {

                       tata.success("Success", response.messages, {
                       position: 'tr',
                       duration: 3000,
                       animate: 'slide'
                       });

                       removeValidationClasses("#user_profile_form");
                       $("#user_profile_form")[0].reset();
                       window.location.reload();

                   }else if(response.status == 401){

                       tata.error("Error", response.messages, {
                       position: 'tr',
                       duration: 3000,
                       animate: 'slide'
                       });

                       $("#user_profile_form")[0].reset();
                       window.location.reload();

                   }

               }
           });
       });

       // password ajax request
       $(document).on('submit', '#user_password_form', function(e) {
           e.preventDefault();
           start_load();
           const fd = new FormData(this);
           $("#user_password_btn").text('<?php echo e(trans('updating')); ?>...');
           $.ajax({
               method: 'POST',
               url: '<?php echo e(route('user.password')); ?>',
               data: fd,
               cache: false,
               contentType: false,
               processData: false,
               dataType: 'json',
               success: function(response) {
                   end_load();

                   if (response.status == 400) {

                       showError('current_password', response.messages.current_password);
                       showError('new_password', response.messages.new_password);
                       showError('confirm_password', response.messages.confirm_password);
                       $("#user_password_btn").text('<?php echo e(trans('save_changes')); ?>');

                   }else if (response.status == 200) {

                       tata.success("Success", response.messages, {
                       position: 'tr',
                       duration: 3000,
                       animate: 'slide'
                       });

                       removeValidationClasses("#user_password_form");
                       $("#user_password_form")[0].reset();
                       window.location.reload();

                   }else if(response.status == 401){

                       tata.error("Error", response.messages, {
                       position: 'tr',
                       duration: 3000,
                       animate: 'slide'
                       });

                       $("#user_password_form")[0].reset();
                       window.location.reload();

                   }

               }
           });
       });

       // email ajax request
       $(document).on('submit', '#user_email_form', function(e) {
           e.preventDefault();
           start_load();
           const fd = new FormData(this);
           $("#user_email_btn").text('<?php echo e(trans('updating')); ?>...');
           $.ajax({
               method: 'POST',
               url: '<?php echo e(route('user.email.notifications')); ?>',
               data: fd,
               cache: false,
               contentType: false,
               processData: false,
               dataType: 'json',
               success: function(response) {
                   end_load();

                   if (response.status == 400) {

                       $("#user_password_btn").text('<?php echo e(trans('save_changes')); ?>');

                   }else if (response.status == 200) {

                       tata.success("Success", response.messages, {
                       position: 'tr',
                       duration: 3000,
                       animate: 'slide'
                       });

                       removeValidationClasses("#user_email_form");
                       $("#user_email_form")[0].reset();
                       window.location.reload();

                   }else if(response.status == 401){

                       tata.error("Error", response.messages, {
                       position: 'tr',
                       duration: 3000,
                       animate: 'slide'
                       });

                       $("#user_email_form")[0].reset();
                       window.location.reload();

                   }

               }
           });
       });

   });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\Tests\ApexForum\resources\views/user/settings/index.blade.php ENDPATH**/ ?>