<?php $__env->startSection('styles'); ?>
<link href="<?php echo e(my_asset('assets/vendors/datatables/dataTables.bootstrap5.css')); ?>" rel="stylesheet">
<link href="<?php echo e(my_asset('assets/vendors/datatables/jquery.dataTables_them.css')); ?>" rel="stylesheet">
<style>
    /* Datatable */
    table.dataTable tbody tr {
        background-color: var(--theme-white) !important;
    }
    .form-select{
        background-color: var(--theme-white) !important;
        color: var(--text-color) !important;
    }
    .form-control{
        background-color: var(--theme-white) !important;
        color: var(--text-color) !important;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="mb-4" data-aos="fade-down" data-aos-easing="linear">
        <h4><i class="bi bi-x-octagon me-2"></i> <?php echo e(trans('user_blocks')); ?></h4>
    </div>

    <?php if(get_setting('payments_on_site') == 'Yes'): ?>
        <?php if(Auth::user()->subscription()->users === 1): ?>
            <div class="dashboard-card" data-aos="fade-up" data-aos-easing="linear">
                <div class="dashboard-header">
                    <h4 class="m-0"><?php echo e(trans('users')); ?></h4>
                </div>
                <div class="dashboard-body">
                    <div class="table-responsive">
                        <!--begin::Table-->
                        <table id="datatable_cms" class="table align-middle table-row-dashed gy-4 mb-0">
                            <thead>
                                <tr class="border-bottom border-gray-200 gs-0">
                                    <th class="min-w-150px"><?php echo e(trans('user')); ?></th>
                                    <th class="min-w-125px"><?php echo e(trans('date')); ?></th>
                                    <th class="min-w-125px"><?php echo e(trans('action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $blocks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $block): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><img src="<?php echo e(my_asset('uploads/users/'.App\Models\User::find($block->block_id)->image)); ?>" class="img-fluid avatar avatar-rounded me-2" width="40px" height="40px" alt="Image">
                                        <?php echo e(App\Models\User::find($block->block_id)->name); ?>

                                        </td>
                                        <td><?php echo e(\Carbon\Carbon::parse($block->created_at)->isoFormat('D MMMM YYYY')); ?></td>
                                        <td><a href="javascript:void(0)" onclick="block('<?php echo e(route('unblock')); ?>','<?php echo e($block->id); ?>','<?php echo e(trans('unblock_user')); ?>?');" class="btn btn-red"><?php echo e(trans('unblock')); ?></a></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        <?php else: ?>

            <div class="dashboard-card" data-aos="fade-up" data-aos-easing="linear">
                <div class="dashboard-body">
                    <div class="upload-image my-3">
                        <h4 class="mb-3"><?php echo e(trans('to_view_blocked_users')); ?>, <?php echo e(trans('you_need_to_purchase_a_new_pricing_plan')); ?>.</h4>
                    </div>
                </div>
            </div><!--/dashboard-card-->

        <?php endif; ?>
    <?php else: ?>
        <div class="dashboard-card" data-aos="fade-up" data-aos-easing="linear">
            <div class="dashboard-header">
                <h4 class="m-0"><?php echo e(trans('users')); ?></h4>
            </div>
            <div class="dashboard-body">
                <div class="table-responsive">
                    <!--begin::Table-->
                    <table id="datatable_cms" class="table align-middle table-row-dashed gy-4 mb-0">
                        <thead>
                            <tr class="border-bottom border-gray-200 gs-0">
                                <th class="min-w-150px"><?php echo e(trans('user')); ?></th>
                                <th class="min-w-125px"><?php echo e(trans('date')); ?></th>
                                <th class="min-w-125px"><?php echo e(trans('action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $blocks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $block): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><img src="<?php echo e(my_asset('uploads/users/'.App\Models\User::find($block->block_id)->image)); ?>" class="img-fluid avatar avatar-rounded me-2" width="40px" height="40px" alt="Image">
                                    <?php echo e(App\Models\User::find($block->block_id)->name); ?>

                                    </td>
                                    <td><?php echo e(\Carbon\Carbon::parse($block->created_at)->isoFormat('D MMMM YYYY')); ?></td>
                                    <td><a href="javascript:void(0)" onclick="block('<?php echo e(route('unblock')); ?>','<?php echo e($block->id); ?>','<?php echo e(trans('unblock_user')); ?>?');" class="btn btn-red"><?php echo e(trans('unblock')); ?></a></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

            </div>
        </div>
    <?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(my_asset('assets/vendors/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(my_asset('assets/vendors/datatables/dataTables.bootstrap5.min.js')); ?>"></script>

    <script>

        $('#datatable_cms').DataTable();

    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\Tests\ApexForum\resources\views/user/blocks/index.blade.php ENDPATH**/ ?>