<?php $__env->startSection('content'); ?>

<main class="content">
    <!-- ========== section start ========== -->
    <section class="section">
      <div class="container-fluid">
      <div class="row mt-50">

        <div class="col-12">
            <?php if(Route::is('admin.plans.list')): ?>
                <div class="card">
                    <div class="card-header">

                        <div class="d-md-flex justify-content-between mb-10">
                            <h5 class="h4 mb-3"><?php echo e(trans('plans')); ?></h5>
                            <div>
                                <a href="<?php echo e(route('admin.plans.add')); ?>" class="btn btn-success mb-0">+ <?php echo e(trans('add')); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <?php $__empty_1 = true; $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="col-lg-4 mb-5">
                            <div class="price">
                                <div class="price-title">
                                    <h4><?php echo e($plan->name); ?></h4>
                                    <h2><span><b><?php echo e(get_setting('currency_symbol')); ?><?php echo e($plan->price); ?></b>/<?php echo e($plan->duration); ?></span></h3>
                                </div>
                                <div class="price-list">
                                    <ul>
                                        <li><i class="bi bi-check2"></i> <?php echo e($plan->points); ?> <?php echo e(trans('points_topup')); ?></li>
                                        <li class="<?php echo e($plan->verified == '0' ? 'price-disable' : ''); ?>">
                                            <i class="bi <?php echo e($plan->verified == '1' ? 'bi-check2' : 'bi-x'); ?> "></i> <?php echo e(trans('verified_checkmark')); ?>

                                        </li>
                                        <li class="<?php echo e($plan->categories == '0' ? 'price-disable' : ''); ?>">
                                            <i class="bi <?php echo e($plan->categories == '1' ? 'bi-check2' : 'bi-x'); ?>"></i> <?php echo e(trans('access_to_pro_categories')); ?>

                                        </li>
                                        <li class="<?php echo e($plan->tips == '0' ? 'price-disable' : ''); ?>">
                                            <i class="bi <?php echo e($plan->tips == '1' ? 'bi-check2' : 'bi-x'); ?>"></i> <?php echo e(trans('access_to_tips')); ?>

                                        </li>
                                        <li class="<?php echo e($plan->comments == '0' ? 'price-disable' : ''); ?>">
                                            <i class="bi <?php echo e($plan->comments == '1' ? 'bi-check2' : 'bi-x'); ?>"></i> <?php echo e(trans('allow_or_close_comments_on_posts')); ?>

                                        </li>
                                        <li class="<?php echo e($plan->reactions == '0' ? 'price-disable' : ''); ?>">
                                            <i class="bi <?php echo e($plan->reactions == '1' ? 'bi-check2' : 'bi-x'); ?>"></i> <?php echo e(trans('show_or_hide_reactions_or_likes_on_posts')); ?>

                                        </li>
                                        <li class="<?php echo e($plan->followers == '0' ? 'price-disable' : ''); ?>">
                                            <i class="bi <?php echo e($plan->followers == '1' ? 'bi-check2' : 'bi-x'); ?>"></i> <?php echo e(trans('allow_user_to_post_discussions_to_only_followers')); ?>

                                        </li>
                                        <li class="<?php echo e($plan->messages == '0' ? 'price-disable' : ''); ?>">
                                            <i class="bi <?php echo e($plan->messages == '1' ? 'bi-check2' : 'bi-x'); ?>"></i> <?php echo e(trans('mute_chat_messages')); ?>

                                        </li>
                                        <li class="<?php echo e($plan->users == '0' ? 'price-disable' : ''); ?>">
                                            <i class="bi <?php echo e($plan->users == '1' ? 'bi-check2' : 'bi-x'); ?>"></i> <?php echo e(trans('block_users')); ?>

                                        </li>
                                        <li class="<?php echo e($plan->viewers == '0' ? 'price-disable' : ''); ?>">
                                            <i class="bi <?php echo e($plan->viewers == '1' ? 'bi-check2' : 'bi-x'); ?>"></i> <?php echo e(trans('view_profile_visitors')); ?>

                                        </li>
                                        <li class="<?php echo e($plan->ads == '0' ? 'price-disable' : ''); ?>">
                                            <i class="bi <?php echo e($plan->ads == '1' ? 'bi-check2' : 'bi-x'); ?>"></i> <?php echo e(trans('no_ads')); ?>

                                        </li>
                                    </ul>
                                </div>
                                <div class="mt-3">
                                    <a href="<?php echo e(route('admin.plans.edit', ['id' => $plan->id])); ?>" class="btn btn-success"><?php echo e(trans('edit')); ?></a>
                                    <a href="javascript:void(0)" onclick="delete_item('<?php echo e(route('admin.plans.destroy')); ?>','<?php echo e($plan->id); ?>','<?php echo e(trans('delete_plan')); ?>?');" class="btn btn-danger"><?php echo e(trans('delete')); ?></a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="col-lg-6">
                            <div class="price">
                                <h4><?php echo e(trans('no_pricing_plans_available')); ?></h4>
                            </div>
                        </div>

                    <?php endif; ?>
                </div>
            <?php elseif(Route::is('admin.plans.add')): ?>

                <div class="card">
                    <div class="card-header">

                        <div class="d-md-flex justify-content-between mb-10">
                            <h5 class="h4 mb-3"><?php echo e(trans('plans')); ?></h5>
                            <div>
                                <a href="<?php echo e(route('admin.plans.list')); ?>" class="btn btn-success mb-0"><?php echo e(trans('list')); ?></a>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card-style settings-card-2 mb-5">
                    <form id="add_plan_form" method="POST">
                        <?php echo csrf_field(); ?>

                        <div class="row px-3 py-3">
                            <div class="col-lg-6">
                                <div class="input-style-1">
                                    <label for="name"><?php echo e(trans('plan_name')); ?></label>
                                    <input name="name" id="name" type="text" placeholder="<?php echo e(trans('plan_name')); ?>" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="input-style-1">
                                    <label for="price"><?php echo e(trans('plan_price')); ?></label>
                                    <input name="price" id="price" type="number" placeholder="<?php echo e(trans('plan_price')); ?>" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="select-style-1">
                                    <label for="duration"><?php echo e(trans('duration')); ?></label>
                                    <div class="select-position">
                                        <select name="duration" id="duration" class="form-select form-control">
                                            <option value="Monthly"><?php echo e(trans('monthly')); ?></option>
                                            <option value="Quarterly"><?php echo e(trans('quarterly')); ?></option>
                                            <option value="Yearly"><?php echo e(trans('yearly')); ?></option>
                                            <option value="Lifetime"><?php echo e(trans('lifetime')); ?></option>
                                        </select>
                                        <div class="invalid-feedback"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="input-style-1">
                                    <label for="points"><?php echo e(trans('points_topup')); ?></label>
                                    <input name="points" id="points" type="number" placeholder="<?php echo e(trans('points_topup')); ?>" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                        <input type="checkbox" name="verified" class="custom-control-input" value="1" id="verified">
                                        <label class="custom-control-label" for="verified"><?php echo e(trans('verified_checkmark')); ?></label>
                                        <p class="text-muted mb-2"></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                        <input type="checkbox" name="categories" class="custom-control-input" value="1" id="categories">
                                        <label class="custom-control-label" for="categories"><?php echo e(trans('access_to_pro_categories')); ?></label>
                                        <p class="text-muted mb-2"></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                        <input type="checkbox" name="tips" class="custom-control-input" value="1" id="tips">
                                        <label class="custom-control-label" for="tips"><?php echo e(trans('access_to_tips')); ?></label>
                                        <p class="text-muted mb-2"></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                        <input type="checkbox" name="comments" class="custom-control-input" value="1" id="comments">
                                        <label class="custom-control-label" for="comments"><?php echo e(trans('allow_or_close_comments_on_posts')); ?></label>
                                        <p class="text-muted mb-2"></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                        <input type="checkbox" name="reactions" class="custom-control-input" value="1" id="reactions">
                                        <label class="custom-control-label" for="reactions"><?php echo e(trans('show_or_hide_reactions_or_likes_on_posts')); ?></label>
                                        <p class="text-muted mb-2"></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                        <input type="checkbox" name="followers" class="custom-control-input" value="1" id="followers">
                                        <label class="custom-control-label" for="followers"><?php echo e(trans('allow_user_to_post_discussions_to_only_followers')); ?></label>
                                        <p class="text-muted mb-2"></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                        <input type="checkbox" name="messages" class="custom-control-input" value="1" id="messages">
                                        <label class="custom-control-label" for="messages"><?php echo e(trans('mute_chat_messages')); ?></label>
                                        <p class="text-muted mb-2"></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                        <input type="checkbox" name="users" class="custom-control-input" value="1" id="users">
                                        <label class="custom-control-label" for="users"><?php echo e(trans('block_users')); ?></label>
                                        <p class="text-muted mb-2"></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                        <input type="checkbox" name="viewers" class="custom-control-input" value="1" id="viewers">
                                        <label class="custom-control-label" for="viewers"><?php echo e(trans('view_profile_visitors')); ?></label>
                                        <p class="text-muted mb-2"></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                        <input type="checkbox" name="ads" class="custom-control-input" value="1" id="ads">
                                        <label class="custom-control-label" for="ads"> <?php echo e(trans('no_ads')); ?></label>
                                        <p class="text-muted mb-2"></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="input-style-1">
                                    <label for="order"><?php echo e(trans('order')); ?></label>
                                    <input name="order" id="order" type="number" placeholder="<?php echo e(trans('order')); ?>" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="select-style-1">
                                    <label for="status"><?php echo e(trans('status')); ?></label>
                                    <div class="select-position">
                                        <select name="status" id="status" class="form-select form-control">
                                            <option value="1"><?php echo e(trans('active')); ?></option>
                                            <option value="0"><?php echo e(trans('not_active')); ?></option>
                                        </select>
                                        <div class="invalid-feedback"></div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12">
                            <button type="submit" class="main-btn primary-btn btn-hover" id="add_plan_btn"><?php echo e(trans('submit')); ?></button>
                            </div>

                        </div>

                    </form>
                </div>

            <?php elseif(Route::is('admin.plans.edit')): ?>

                <div class="card">
                    <div class="card-header">

                        <div class="d-md-flex justify-content-between mb-10">
                            <h5 class="h4 mb-3"><?php echo e(trans('edit')); ?></h5>
                            <div>
                                <a href="<?php echo e(route('admin.plans.list')); ?>" class="btn btn-success mb-0"><?php echo e(trans('list')); ?></a>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card-style settings-card-2 mb-5">
                    <form id="edit_plan_form" method="POST">
                        <?php echo csrf_field(); ?>

                        <input type="hidden" name="id" id="id" value="<?php echo e($plan->id); ?>">

                        <div class="row px-3 py-3">
                            <div class="col-lg-6">
                                <div class="input-style-1">
                                    <label for="name"><?php echo e(trans('plan_name')); ?></label>
                                    <input name="name" id="name" type="text" value="<?php echo e($plan->name); ?>">
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="input-style-1">
                                    <label for="price"><?php echo e(trans('plan_price')); ?></label>
                                    <input name="price" id="price" type="number" value="<?php echo e($plan->price); ?>">
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="select-style-1">
                                    <label for="duration"><?php echo e(trans('duration')); ?></label>
                                    <div class="select-position">
                                        <select name="duration" id="duration" class="form-select form-control">
                                            <option value="Monthly" <?php echo e($plan->duration == 'Monthly' ? 'selected="selected"' : ''); ?>><?php echo e(trans('monthly')); ?></option>
                                            <option value="Quarterly" <?php echo e($plan->duration == 'Quarterly' ? 'selected="selected"' : ''); ?>><?php echo e(trans('quarterly')); ?></option>
                                            <option value="Yearly" <?php echo e($plan->duration == 'Yearly' ? 'selected="selected"' : ''); ?>><?php echo e(trans('yearly')); ?></option>
                                            <option value="Lifetime" <?php echo e($plan->duration == 'Lifetime' ? 'selected="selected"' : ''); ?>><?php echo e(trans('lifetime')); ?></option>
                                        </select>
                                        <div class="invalid-feedback"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="input-style-1">
                                    <label for="points"><?php echo e(trans('points_topup')); ?></label>
                                    <input name="points" id="points" type="number" value="<?php echo e($plan->points); ?>" >
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                        <input type="checkbox" name="verified" class="custom-control-input" value="1" id="verified" <?php echo e($plan->verified == '1' ? 'checked' : ''); ?>>
                                        <label class="custom-control-label" for="verified"><?php echo e(trans('verified_checkmark')); ?></label>
                                        <p class="text-muted mb-2"></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                        <input type="checkbox" name="categories" class="custom-control-input" value="1" id="categories" id="verified" <?php echo e($plan->categories == '1' ? 'checked' : ''); ?>>
                                        <label class="custom-control-label" for="categories"><?php echo e(trans('access_to_pro_categories')); ?></label>
                                        <p class="text-muted mb-2"></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                        <input type="checkbox" name="tips" class="custom-control-input" value="1" id="tips" <?php echo e($plan->tips == '1' ? 'checked' : ''); ?>>
                                        <label class="custom-control-label" for="tips"><?php echo e(trans('access_to_tips')); ?></label>
                                        <p class="text-muted mb-2"></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                        <input type="checkbox" name="comments" class="custom-control-input" value="1" id="comments" <?php echo e($plan->comments == '1' ? 'checked' : ''); ?>>
                                        <label class="custom-control-label" for="comments"><?php echo e(trans('allow_or_close_comments_on_posts')); ?></label>
                                        <p class="text-muted mb-2"></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                        <input type="checkbox" name="reactions" class="custom-control-input" value="1" id="reactions" <?php echo e($plan->reactions == '1' ? 'checked' : ''); ?>>
                                        <label class="custom-control-label" for="reactions"><?php echo e(trans('show_or_hide_reactions_or_likes_on_posts')); ?></label>
                                        <p class="text-muted mb-2"></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                        <input type="checkbox" name="followers" class="custom-control-input" value="1" id="followers" <?php echo e($plan->followers == '1' ? 'checked' : ''); ?>>
                                        <label class="custom-control-label" for="followers"><?php echo e(trans('allow_user_to_post_discussions_to_only_followers')); ?></label>
                                        <p class="text-muted mb-2"></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                        <input type="checkbox" name="messages" class="custom-control-input" value="1" id="messages" <?php echo e($plan->messages == '1' ? 'checked' : ''); ?>>
                                        <label class="custom-control-label" for="messages"><?php echo e(trans('mute_chat_messages')); ?></label>
                                        <p class="text-muted mb-2"></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                        <input type="checkbox" name="users" class="custom-control-input" value="1" id="users" <?php echo e($plan->users == '1' ? 'checked' : ''); ?>>
                                        <label class="custom-control-label" for="users"><?php echo e(trans('block_users')); ?></label>
                                        <p class="text-muted mb-2"></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                        <input type="checkbox" name="viewers" class="custom-control-input" value="1" id="viewers" <?php echo e($plan->viewers == '1' ? 'checked' : ''); ?>>
                                        <label class="custom-control-label" for="viewers"><?php echo e(trans('view_profile_visitors')); ?></label>
                                        <p class="text-muted mb-2"></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                        <input type="checkbox" name="ads" class="custom-control-input" value="1" id="ads" <?php echo e($plan->ads == '1' ? 'checked' : ''); ?>>
                                        <label class="custom-control-label" for="ads"> <?php echo e(trans('no_ads')); ?></label>
                                        <p class="text-muted mb-2"></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="input-style-1">
                                    <label for="order"><?php echo e(trans('oder')); ?></label>
                                    <input name="order" id="order" type="number" value="<?php echo e($plan->order); ?>" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="select-style-1">
                                    <label for="status"><?php echo e(trans('status')); ?></label>
                                    <div class="select-position">
                                        <select name="status" id="status" class="form-select form-control">
                                            <option value="1" <?php echo e($plan->status == '1' ? 'selected="selected"' : ''); ?>><?php echo e(trans('active')); ?></option>
                                            <option value="0" <?php echo e($plan->status == '0' ? 'selected="selected"' : ''); ?>><?php echo e(trans('not_active')); ?></option>
                                        </select>
                                        <div class="invalid-feedback"></div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12">
                            <button type="submit" class="main-btn primary-btn btn-hover" id="edit_plan_btn"><?php echo e(trans('submit')); ?></button>
                            </div>

                        </div>

                    </form>
                </div>
            <?php endif; ?>
        </div>


      </div><!-- row -->
     </div><!-- container -->
    </section>

</main>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    //Add Plan
    $(document).on('submit', '#add_plan_form', function(e) {
      e.preventDefault();
      start_load();
      const fd = new FormData(this);
      $("#add_plan_btn").text('<?php echo e(trans('adding')); ?>...');
      $.ajax({
        url: '<?php echo e(route('admin.plans.add')); ?>',
        method: 'post',
        data: fd,
        cache: false,
        contentType: false,
        processData: false,
        dataType: 'json',
        success: function(response) {

          end_load();

          if (response.status == 400) {

              showError('name', response.messages.name);
              showError('price', response.messages.price);
              showError('points', response.messages.points);
              showError('order', response.messages.order);
              $("#add_plan_btn").text('<?php echo e(trans('submit')); ?>');

          }else if (response.status == 200) {

              tata.success("Success", response.messages, {
              position: 'tr',
              duration: 3000,
              animate: 'slide'
              });

              window.location.reload();

          }else if(response.status == 401){

              tata.error("Error", response.messages, {
              position: 'tr',
              duration: 3000,
              animate: 'slide'
              });

              window.location.reload();

          }

        }
      });
    });


    //Edit Plan
    $(document).on('submit', '#edit_plan_form', function(e) {
      e.preventDefault();
      start_load();
      const fd = new FormData(this);
      $("#edit_plan_btn").text('<?php echo e(trans('updating')); ?>...');
      $.ajax({
        url: '<?php echo e(route('admin.plans.update')); ?>',
        method: 'post',
        data: fd,
        cache: false,
        contentType: false,
        processData: false,
        dataType: 'json',
        success: function(response) {

          end_load();

          if (response.status == 400) {

              showError('name', response.messages.name);
              showError('price', response.messages.price);
              showError('points', response.messages.points);
              showError('order', response.messages.order);
              $("#edit_plan_btn").text('<?php echo e(trans('submit')); ?>');

          }else if (response.status == 200) {

              tata.success("Success", response.messages, {
              position: 'tr',
              duration: 3000,
              animate: 'slide'
              });

              window.location.reload();

          }else if(response.status == 401){

              tata.error("Error", response.messages, {
              position: 'tr',
              duration: 3000,
              animate: 'slide'
              });

              window.location.reload();

          }

        }
      });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\Tests\ApexForum\resources\views/admin/plans/index.blade.php ENDPATH**/ ?>