<?php $__env->startSection('content'); ?>

<main class="content">
    <!-- ========== section start ========== -->
    <section class="section">
      <div class="container-fluid">
      <div class="row mt-50">


        <div class="col-12">
            <div class="card">
                <div class="card-header">

                    <div class="d-md-flex justify-content-between align-items-center mb-10">
                        <h5 class="h4 mb-0"><?php echo e(trans('countries')); ?></h5>
                        <div>
                            <button type="button" class="btn btn-success mb-3" data-bs-toggle="modal" data-bs-target="#addCountryModal">+ <?php echo e(trans('add')); ?></button>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                <div class="table-responsive">
                    <table id="datatable_cms" class="table table-bordered table-reload">

                        <thead>
                            <tr>
                                <th>#</th>
                                <th><?php echo e(trans('name')); ?></th>
                                <th><?php echo e(trans('code')); ?></th>
                                <th><?php echo e(trans('status')); ?></th>
                                <th class="text-right"><?php echo e(trans('options')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $country; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $co): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(($key+1)); ?></td>
                                    <td><?php echo e($co->name); ?></td>
                                    <td><?php echo e($co->code); ?></td>
                                    <?php if($co->status == 1): ?>
                                     <td> <span class="badge bg-success"><?php echo e(trans('active')); ?></span> </td>
                                    <?php else: ?>
                                    <td> <span class="badge bg-danger"><?php echo e(trans('not_active')); ?></span> </td>
                                    <?php endif; ?>
                                    <td class="text-right">

                                        <a  href="#" id="<?php echo e($co->id); ?>" class="btn btn-soft-success btn-icon btn-circle btn-sm btn icon editIcon" title="Edit">
                                            <i class="align-middle" data-feather="edit-2"></i>
                                        </a>
                                        <a href="javascript:void(0)" class="btn btn-soft-danger btn-icon btn-circle btn-sm confirm-delete" title="Delete"
                                        onclick="delete_item('<?php echo e(route('admin.country.destroy')); ?>','<?php echo e($co->id); ?>','<?php echo e(trans('delete_this_country')); ?>');">
                                            <i class="align-middle" data-feather="trash"></i>
                                        </a>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                </div>
            </div>
        </div>




        
        <div class="modal fade" id="addCountryModal" tabindex="-1" aria-labelledby="exampleModalLabel" data-bs-backdrop="static" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><?php echo e(trans('add_country')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="model-body">

                    <form id="add_country_form" action="" method="POST">
                        <?php echo csrf_field(); ?>

                        <div class="row px-3 py-3">
                            <div class="col-12">
                                <div class="input-style-1">
                                    <label for="name"><?php echo e(trans('name')); ?></label>
                                    <input type="text" name="name" id="name" placeholder="Eg. United States of America" class="form-control my-2">
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="input-style-1">
                                    <label for="code"><?php echo e(trans('code')); ?></label>
                                    <input type="text" name="code" id="code" placeholder="Eg. US" class="form-control my-2">
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="input-style-1">
                                    <label for="status"><?php echo e(trans('status')); ?></label>
                                    <select name="status" id="status" class="form-select form-control">
                                        <option value="1"><?php echo e(trans('active')); ?></option>
                                        <option value="0"><?php echo e(trans('not_active')); ?></option>
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                        </div>

                        <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(trans('close')); ?></button>
                        <button type="submit" id="add_country_btn" class="btn btn-success"><?php echo e(trans('add')); ?></button>
                        </div>
                    </form>

                </div>
                </div>
            </div>
        </div>
        

        
        <div class="modal fade" id="editCountryModal" tabindex="-1" aria-labelledby="exampleModalLabel" data-bs-backdrop="static" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><?php echo e(trans('edit_country')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="model-body">

                    <form id="edit_country_form" action="" method="POST">
                        <?php echo csrf_field(); ?>

                        <input type="hidden" name="country_id" id="country_id">
                        <div class="row px-3 py-3">
                            <div class="col-12">
                                <div class="input-style-1">
                                    <label for="name"><?php echo e(trans('name')); ?></label>
                                    <input type="text" name="name" id="name" placeholder="Eg. United States of America" class="form-control my-2">
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="input-style-1">
                                    <label for="code"><?php echo e(trans('code')); ?></label>
                                    <input type="text" name="code" id="code" placeholder="Eg. US" class="form-control my-2">
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="input-style-1">
                                    <label for="status"><?php echo e(trans('status')); ?></label>
                                    <select name="status" id="status" class="form-select form-control">
                                        <option value="1"><?php echo e(trans('active')); ?></option>
                                        <option value="0"><?php echo e(trans('not_active')); ?></option>
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                        </div>

                        <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(trans('close')); ?></button>
                        <button type="submit" id="edit_country_btn" class="btn btn-success"><?php echo e(trans('update')); ?></button>
                        </div>
                    </form>

                </div>
                </div>
            </div>
        </div>
        

    </div><!-- row -->
   </div><!-- container -->
  </section>

</main>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('scripts'); ?>

<script>
    $(function() {

        // add category ajax request
        $(document).on('submit', '#add_country_form', function(e) {
            e.preventDefault();
            start_load();
            const fd = new FormData(this);
            $("#add_country_btn").text('<?php echo e(trans('adding')); ?>...');
            $.ajax({
            url: '<?php echo e(route('admin.country.add')); ?>',
            method: 'post',
            data: fd,
            cache: false,
            contentType: false,
            processData: false,
            dataType: 'json',
            success: function(response) {

                end_load();

                if (response.status == 400) {

                    showError('name', response.messages.name);
                    showError('code', response.messages.code);
                    showError('status', response.messages.status);
                    $("#add_country_btn").text('<?php echo e(trans('add')); ?>');

                }else if (response.status == 200) {

                    tata.success("Success", response.messages, {
                    position: 'tr',
                    duration: 3000,
                    animate: 'slide'
                    });

                    removeValidationClasses("#add_country_form");
                    $("#add_country_form")[0].reset();
                    $("#addCountryModal").modal('hide');
                    window.location.reload();

                }else if(response.status == 401){

                    tata.error("Error", response.messages, {
                    position: 'tr',
                    duration: 3000,
                    animate: 'slide'
                    });

                    $("#add_country_form")[0].reset();
                    $("#addCountryModal").modal('hide');
                    window.location.reload();

                }

            }
            });
        });

        // edit category ajax request
        $(document).on('click', '.editIcon', function(e) {
            e.preventDefault();
            start_load();
            let id = $(this).attr('id');
            $.ajax({
                url: '<?php echo e(route('admin.country.edit')); ?>',
                method: 'get',
                data: {
                id: id,
                },
                success: function(response) {
                    end_load();

                    $('#editCountryModal').modal('show');

                    $('#edit_country_form #name').val(response.name);
                    $('#edit_country_form #code').val(response.code);
                    $('#edit_country_form #country_id').val(response.id);
                    if (response.status == 1) {
                        $("#edit_country_form #status option[value=1]").attr('selected', 'selected');
                    } else {
                        $("#edit_country_form #status option[value=0]").attr('selected', 'selected');
                    }

                }
            });
        });

        // update category ajax request
        $(document).on('submit', '#edit_country_form', function(e) {
            e.preventDefault();
            start_load();
            const fd = new FormData(this);
            $("#edit_country_btn").text('<?php echo e(trans('updating')); ?>...');
            $.ajax({
                method: 'POST',
                url: '<?php echo e(route('admin.country.update')); ?>',
                data: fd,
                cache: false,
                contentType: false,
                processData: false,
                dataType: 'json',
                success: function(response) {
                    end_load();

                    if (response.status == 400) {

                        showError('name', response.messages.name);
                        showError('code', response.messages.code);
                        showError('status', response.messages.status);
                        $("#edit_country_btn").text('<?php echo e(trans('submit')); ?>');

                    }else if (response.status == 200) {

                        tata.success("Success", response.messages, {
                        position: 'tr',
                        duration: 3000,
                        animate: 'slide'
                        });

                        removeValidationClasses("#edit_country_form");
                        $("#edit_country_form")[0].reset();
                        $("#editCountryModal").modal('hide');
                        window.location.reload();

                    }else if(response.status == 401){

                        tata.error("Error", response.messages, {
                        position: 'tr',
                        duration: 3000,
                        animate: 'slide'
                        });

                        $("#edit_country_form")[0].reset();
                        $("#editCountryModal").modal('hide');
                        window.location.reload();

                    }

                }
            });
        });

    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\Tests\ApexForum\resources\views/admin/country/index.blade.php ENDPATH**/ ?>