<?php

namespace App\Http\Controllers\Auth;

use App\Models\User;
use App\Models\Plans;
use App\Models\Points;
use App\Models\Transaction;
use Illuminate\Support\Str;
use App\Models\Subscription;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Http\RedirectResponse;
use Laravel\Socialite\Facades\Socialite;

class GoogleController extends Controller
{
    public function redirectToGoogle(): RedirectResponse
    {
        return Socialite::driver('google')->redirect();
    }

    public function handleGoogleCallback(): RedirectResponse
    {
        $user = Socialite::driver('google')->user();

        $existingUser = User::where('google_id', $user->id)->first();

        if ($existingUser) {
            // Log in the existing user.
            auth()->login($existingUser, true);
        } else {

            //Plan
            $plan = Plans::where('price', '0.00')->first();

            if ($plan->duration == 'Monthly') {
                $new_date = Carbon::now()->addMonth();
            }elseif($plan->duration == 'Quaterly'){
                $new_date = Carbon::now()->addMonths('4');
            }elseif($plan->duration == 'Yearly'){
                $new_date = Carbon::now()->addYear();
            }elseif($plan->duration == 'Lifetime'){
                $new_date = Carbon::now()->addYears(50);
            }


            // Create a new user.
            $newUser = new User();
            $newUser->name = $user->name;
            $newUser->slug = Str::slug($user->name);
            $newUser->username = generateUsername($user->name);
            $newUser->email = $user->email;
            $newUser->google_id = $user->id;
            $newUser->password = bcrypt(request(Str::random())); // Set some random password
            $newUser->image = getSocialAvatar($user->getAvatar(), '/uploads/users/', $user);
            $newUser->wallet = '0.00';
            $newUser->earnings = '0.00';
            $newUser->plan_id = $plan->id;
            if ($plan->verified == 1) {
                $newUser->verified = '1';
            }else {
                $newUser->verified = '0';
            }

            if ($newUser->save()) {

                Auth::login($newUser);

                $sub = Subscription::create([
                    'user_id' => Auth::user()->id,
                    'plan_id' => $plan->id,
                    'price' => $plan->price,
                    'points' => $plan->points,
                    'verified' => $plan->verified,
                    'categories' => $plan->categories,
                    'tips' => $plan->tips,
                    'comments' => $plan->comments,
                    'reactions' => $plan->reactions,
                    'followers' => $plan->followers,
                    'messages' => $plan->messages,
                    'users' => $plan->users,
                    'viewers' => $plan->viewers,
                    'ads' => $plan->ads,
                    'status' => 1,
                    'will_expire' => $new_date
                ]);

                Transaction::create([
                    'user_id' => Auth::user()->id,
                    'type_id' => $sub->id,
                    'type' => '1', //Subscription
                    'amount' => $plan->price,
                    'status' => '1'
                ]);

                if(get_setting('points_system') == 1){
                    Points::create([
                        'user_id' => Auth::user()->id,
                        'type' => '2',
                        'score' => get_setting('registration')
                    ]);

                    Points::create([
                        'user_id' => Auth::user()->id,
                        'type' => '9',
                        'score' => $plan->points
                    ]);
                }

            }

        }

         // Redirect to url as requested by user, if empty use /dashboard page as generated by Jetstream
        return redirect()->route('home');
    }
}
